#!/bin/bash

# please enter website's base directory
basedir="$HOME/test"

# script starts here

# check if the base directory exists and has an events subdirectory
[ ! -d $basedir ] && echo "$basedir does not exist!" && exit 1
[ ! -d $basedir/events ] && echo "$basedir does not contain an events directory!" && exit 1

# create the events folder for the specified year if it doesn't exist    
[ ! -d  $basedir/events/$usedyear ] && mkdir -p $basedir/events/$usedyear && echo "Events directory for $usedyear created."

# read event date
echo "If you do not enter a date below, today is used."
read -p "Enter the date of the event: " date

# check if date expression is valid
eval "date -d \"$date\"" > /dev/null 2> /dev/null
if [ $? != 0 ]; then

  echo "Invalid date expression"
  exit 1

fi
# date for filename
filedate=$(date -d "$date" +%Y%m%d)

# date for file content
useddate=$(date -d "$date" +%Y-%m-%d)

# year for events subfolder
usedyear=$(date -d "$date" +%Y)

# list locations and read the desired one
alllocations=$(ls buildingblocks/ |grep -v general)
echo "The following locations are available: "
echo $alllocations

read -p "Please enter the desired location: " location

# walk through all available language building blocks

# if $go is not zero, we can safely start writing the files without 
# overwriting old stuff
go=0

# $ count is used for the filename. If there is already an event 
# on the date specified, we increase this until we have a "free" file name
count=1

# walk through all the languages available for the specified location
for lang in $(ls buildingblocks/$location/); do

  # $finished is set to 1 after the file has been written; this does not happen 
  # before we don't have a usable serial number for our event entries
  finished=0
  while [ $finished -eq 0 ]; do

    # event serial number must have two digits
    if [ $count -lt 10 ];then
      newcount="0$count"
    else
      newcount=$count
    fi

    # file name for our event
    file="$basedir/events/$usedyear/event-$filedate-$newcount.$lang"

    # finds all files with the name we want to use
    todaycontent=$(find $basedir/events/$usedyear/ -type f |grep -i event-$filedate-$newcount)

    # if the list created above is *not* empty, we try the next serial number
    # otherwise, we set $go to 1 so we know it's save to start writing files
    if [ "$todaycontent" != "" ]; then
      [ $go -eq 0 ] && count=$[$count+1]
    else
      go=1
    fi
    
    # only write those files if $go has been set to 1!
    if [ $go -eq 1 ]; then
      cat buildingblocks/general/head > $file
      echo "   <event start=\"$useddate\" end=\"$useddate\">" >> $file
      cat buildingblocks/$location/$lang >> $file
      cat buildingblocks/general/tail >> $file
      echo "file $file written"
      finished=1
    fi
  done

done
